﻿//////////////////////////////////////////////
// EnvironmentRenderer.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkAstraeus
{
	class EnvironmentRendererData ;
	class System ;
}

namespace nkGraphics
{
	class Shader ;
	class Texture ;
}

/// Includes ---------------------------------

// nkAstraeus
#include "../../Dll/DllDefines.h"

// nkGraphics
#include <NilkinsGraphics/Utils/DxDefinesWrapper.h>

// nkMemory
#include <NilkinsMemory/Pointers/UniquePtr.h>

/// Class ------------------------------------

namespace nkAstraeus
{
	class DLL_ASTRAEUS_EXPORT EnvironmentRenderer final
	{
		public :

			// Constructor, destructor
			EnvironmentRenderer (System* system) noexcept ;
			~EnvironmentRenderer () ;

			// Rendering
			void renderCubemap (nkGraphics::Texture* output, nkGraphics::Shader* shader, unsigned int targetDimensions, nkGraphics::FORMAT targetFormat) ;
			void cubemapToSphericalMap (nkGraphics::Texture* output, nkGraphics::Texture* input, unsigned int targetWidth, unsigned int targetHeight) ;

		private :

			// Setup
			void _setupData () ;

		private :

			// Attributes
			System* _system ;
			nkMemory::UniquePtr<EnvironmentRendererData> _data ;
	} ;
}